package gov.va.med.mhv.journal.service.validator;

import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.journal.dto.ActivityDetailDTO;
import gov.va.med.mhv.journal.enums.ActivityTypeEnumeration;
import gov.va.med.mhv.journal.web.util.JournalMessagesUtil;

import java.util.LinkedHashMap;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActivityDetailValidator {

	public static final int ITEM_MAX_LENGTH = 50;

	@Autowired
	private JournalMessagesUtil messagesUtil;
	
	/**
	 * Validates createdDate
	 */
	/*protected void validateCreatedDate(ActivityDetailDTO activityDetailDTO, LinkedHashMap<String, String> validationErrors) {
		Date value = activityDetailDTO.get();
		//check requiredness:		
		if( value == null ) {
			Validations.validateRequired("CreatedDate", null, validationErrors);
						
			//no need to continue:
			return;
		}		
	}	
	*/
	
	/**
	 * Validates Activity Description
	 */
	protected void validateActivityDesc(ActivityDetailDTO activityDetailDTO, LinkedHashMap<String, String> validationErrors) {
		String value = StringUtils.trimToNull(activityDetailDTO.getDescription());
		//check requiredness:		
		if( value == null ) {
			Validations.validateRequired("Activity Description", value, validationErrors);
						
			//no need to continue:
			return;
		}		
		//check max length
		Validations.validateMaxLength("Activity Description", value, ITEM_MAX_LENGTH, validationErrors);
	}	
	
/*	
	*//**
	 * Validates modifiedDate
	 *//*
	protected void validateModifiedDate(ActivityDetailDTO activityDetailDTO, LinkedHashMap<String, String> validationErrors) {
		Date value = activityDetailDTO.getM();
		//check for a value to validate:
		if ( value == null ) {
			//nothing to validate
			return;
		}						
	}	*/
	
	
	/**
	 * Validates Activity Type
	 */
	protected void validateActivityType(ActivityDetailDTO activityDetailDTO, LinkedHashMap<String, String> validationErrors) {
		String value = StringUtils.trimToNull(activityDetailDTO.getActivityType());
		//check requiredness:
		if( value == null ) {
			Validations.validateRequired("Activity Type", value, validationErrors);
						
			//no need to continue:
			return;
		}		
		
		//validate a valid enumeration value:
		boolean valid = false;
		if (Validations.hasValue(value)) {
			for (ActivityTypeEnumeration s : ActivityTypeEnumeration.values()) {
				if (s.getActivityType().equals(value)) {
					valid = true;
					break;
				}
			}
			
			if (!valid) {
				validationErrors.put(messagesUtil.getActivityTypeRequired(), messagesUtil.getActivityTypeRequired());
			}
		}
	
	}
	
	
	/**
	 * Executes all field-level validations
	 */
	public ResponseUtil<ActivityDetailDTO> fieldValidation(ActivityDetailDTO activityDetailDTO) {
		ResponseUtil<ActivityDetailDTO> response = new ResponseUtil<ActivityDetailDTO>();
		LinkedHashMap<String, String> validationErrors = new LinkedHashMap<String, String>();
		
		validateActivityType(activityDetailDTO, validationErrors);
		validateActivityDesc(activityDetailDTO, validationErrors);
	
		
		response.setValidationErrors(validationErrors);
		
		return response;
	}	
}